use strict;
use IO::Socket::SSL;
use Socket;
use Net::SSLeay;
use MIME::Base64 qw();
use IO::File;

# -------------------------------- OpenSocket

sub OpenSocket {
    # use Devel::StackTrace; print Devel::StackTrace->new( max_arg_length => 200 )->as_string();
    my ($sHost, $iPort) = @_;

    my %hParams = (SSL_verify_mode => SSL_VERIFY_PEER);

    $hParams{SSL_ca_file}   = $ENV{HTTPS_CA_FILE}   if ( $ENV{HTTPS_CA_FILE}  );
    $hParams{SSL_ca_path}   = $ENV{HTTPS_CA_PATH}   if ( $ENV{HTTPS_CA_PATH}  );
    if ( ! $hParams{SSL_ca_path} )
        {
        $hParams{SSL_ca_path}   = $ENV{HTTPS_CA_DIR}   if ( $ENV{HTTPS_CA_DIR}  );
        }
    $hParams{SSL_cert_file} = $ENV{HTTPS_CERT_FILE} if ( $ENV{HTTPS_CERT_FILE});
    $hParams{SSL_key_file}  = $ENV{HTTPS_KEY_FILE}  if ( $ENV{HTTPS_KEY_FILE} );
    $hParams{SSL_version}   = $ENV{HTTPS_VERSION}   if ( $ENV{HTTPS_VERSION}  );
    $hParams{SSL_verify_mode}   = SSL_VERIFY_PEER   if ( $ENV{HTTPS_VERIFY_MODE} && $ENV{HTTPS_VERIFY_MODE} =~ m/peer/i );
    $hParams{SSL_verify_mode}   = SSL_VERIFY_NONE   if ( $ENV{HTTPS_VERIFY_MODE} && $ENV{HTTPS_VERIFY_MODE} =~ m/none/i );

    if (defined($ENV{HTTPS_PROXY}) && $ENV{HTTPS_PROXY} =~ m/^\s*(\S+?):(\d+)\s*$/) {
        my ($sProxyHost, $iProxyPort) = ($1, $2);

        my $CRLF = "\x0d\x0a";
        my $dest_ip     = gethostbyname($sProxyHost);
        my $host_params = sockaddr_in($iProxyPort, $dest_ip);
        socket(my $socket, &PF_INET(), &SOCK_STREAM(), 0) or die "socket: $!";
        connect($socket, $host_params)                    or die "connect: $!";
        my $old_select = select($socket); $| = 1; select($old_select);

        my $sProxyUsername = ( defined( $ENV{HTTPS_PROXY_USERNAME} ) ? $ENV{HTTPS_PROXY_USERNAME} : '' );
        my $sProxyPassword = ( defined( $ENV{HTTPS_PROXY_PASSWORD} ) ? $ENV{HTTPS_PROXY_PASSWORD} : '' );
        my $sProxyAuth = $sProxyUsername ? $CRLF . 'Proxy-authorization: Basic ' . MIME::Base64::encode("$sProxyUsername:$sProxyPassword", '') : '';
        print $socket "CONNECT $sHost:$iPort HTTP/1.0$sProxyAuth$CRLF$CRLF";
        my $line = <$socket>;

        # upgrade the TCP socket to TLS
        $socket = IO::Socket::SSL->start_SSL($socket,
                                  # hostname is needed for SNI and certificate validation
                                  SSL_hostname => $sHost,
                                  %hParams
        ) or die $SSL_ERROR;

        return $socket;
    } else {
        return IO::Socket::SSL->new(PeerHost => $sHost, PeerPort => $iPort, %hParams);
    }
}

sub HTTPGET_IO_SOCKET_SSL {
    my ($phRequest, $iHttpVerbose, $phErrorMeaning, $phIniFile, $fAppendLog) = @_;

    my $szHost = $phRequest->{sHost};
    my $port   = $phRequest->{iPort};

    my $func="HTTPGET_IO_SOCKET_SSL";

    my $sock = eval{OpenSocket($szHost, $port)};

    return("$func:EC1010:".$@."\n$phErrorMeaning->{1010}.")if ( $@ || ! $sock );

    if ( $iHttpVerbose > 0 ) {

        my $out='';
        $out .="SSL connection through Proxy:".$phIniFile->{'http_session_header'}."\n" if defined ( $phIniFile->{'http_session_header'});
        $out .= "WEB SITE       : $szHost:$port\n";
        $out .= "CIPHER         : ".$sock->get_cipher."\n";
        my $cert = $sock->get_peer_certificate;

        $out .= "CERT SUBJECT   : ".$cert->subject_name."\n";
        $out .= "CERTIFIED BY   : ".$cert->issuer_name."\n";
        #$out .= "CERT NOT BEFORE: ".$cert->not_before."\n";
        #$out .= "CERT NOT AFTER : ".$cert->not_after."\n";
        $fAppendLog->($out);
    }

    $sock->print( $phRequest->{'sMethod'} . ' ' . $phRequest->{'sPath'} . ' ' . $phRequest->{'sHttpVersion'} ."\r\n");
    $sock->print(join('', map {"$_->[0]: $_->[1]\r\n"} @{$phRequest->{'paHeaders'}}));
    $sock->print( "\r\n");
    $sock->print($phRequest->{sBody});

    my $sTempBinFile = $phRequest->{'sOutputFn'};
    my $sTempFH=IO::File->new(">$sTempBinFile")||return("$func: Can't write $sTempBinFile. Please make sure autodnld has write access to this directory");
    my $szBuf='';
    while (my $szTotalByte=$sock->read($szBuf,8192,length($szBuf))) {
        $sTempFH->syswrite($szBuf);
        $szBuf='';
        $fAppendLog->("Received $szTotalByte Bytes") if ( $iHttpVerbose > 0 );
    }
    close($sock);

    $fAppendLog->("Finished writing to file:".$sTempBinFile) if ( $iHttpVerbose > 0 );

    $sTempFH->close();
    return ('',$sTempBinFile);
}

################HTTPConnect: Generate header and download stream, save to a temp binary file############
# return ($Err_msg,$sTempBinFile)
sub HTTPConnect_IO_SOCKET_SSL {
    my ($phRequest, $iHttpVerbose, $phErrorMeaning, $phIniFile, $fAppendLog) = @_;

    my $szHost = $phRequest->{sHost};
    my $port   = $phRequest->{iPort};


    my $func="HTTPConnect_IO_SOCKET_SSL";

    my $sock = eval{OpenSocket($szHost, $port)};

   return("$func:EC1010:".$@."\n$phErrorMeaning->{1010}.")if ( $@ || ! $sock );

   if ( $iHttpVerbose > 0 ) {

       my $out='';
       $out .="SSL connection through Proxy:".$phIniFile->{'http_session_header'}."\n" if defined ( $phIniFile->{'http_session_header'});
       $out .= "WEB SITE       : $szHost:$port\n";
       $out .= "CIPHER         : ".$sock->get_cipher."\n";
       my $cert = $sock->get_peer_certificate;

       $out .= "CERT SUBJECT   : ".$cert->subject_name."\n";
       $out .= "CERTIFIED BY   : ".$cert->issuer_name."\n";
       #$out .= "CERT NOT BEFORE: ".$cert->not_before."\n";
       #$out .= "CERT NOT AFTER : ".$cert->not_after."\n";

       $fAppendLog->($out);
   }

   # $fAppendLog->( "Content length=$iContentLength\n") if ( $iHttpVerbose > 0 );
   $|=1;
   $sock->print( $phRequest->{'sMethod'} . ' ' . $phRequest->{'sPath'} . ' ' . $phRequest->{'sHttpVersion'} ."\r\n");
   #$sock->print( "Accept: application/x-ms-application, image/jpeg, application/xaml+xml, image/gif, image/pjpeg, application/x-ms-xbap, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*\r\n");
   #$sock->print( "Referer: http://$szHost/shiptest.html\r\n");
   $sock->print(join('', map {"$_->[0]: $_->[1]\r\n"} @{$phRequest->{'paHeaders'}}));
   $sock->print( "\r\n");
   $sock->print($phRequest->{sBody});

   my $sTempBinFile = $phRequest->{'sOutputFn'};
   my $sTempFH=IO::File->new(">$sTempBinFile")||return("$func: Can't write $sTempBinFile. Please make sure autodnld has write access to this directory");
   my $szBuf='';
   while (my $szTotalByte=$sock->read($szBuf,8192,length($szBuf))) {
       $sTempFH->syswrite($szBuf);
       $szBuf='';
      $fAppendLog->("Received $szTotalByte Bytes") if ( $iHttpVerbose > 0 );
   }
   close($sock);

   $fAppendLog->("Finished writing to file:".$sTempBinFile) if ( $iHttpVerbose > 0 );

   $sTempFH->close();
   return ('',$sTempBinFile);
}

1;
